<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Dynamic Column Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array(
        array("label"=> "Core 1", "y"=> 20),
        array("label"=> "Core 2", "y"=> 65),
        array("label"=> "Core 3", "y"=> 11),
        array("label"=> "Core 4", "y"=> 5),
        array("label"=> "Core 5", "y"=> 48),
        array("label"=> "Core 6", "y"=> 8),
        array("label"=> "Core 7", "y"=> 2),
        array("label"=> "Core 8", "y"=> 18)
    );
?>

<script>
    window.onload = function () {
        var chart = new CanvasJS.Chart("chartContainer", {
            title: {
                text: "CPU Usage in 8-Core Processor"
            },
            axisY: {
                minimum: 0,
                maximum: 100,
                suffix: "%"
            },
            data: [{
                type: "column",
                yValueFormatString: "#,##0.00\"%\"",
                indexLabel: "{y}",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        
        function updateChart() {
            var color,deltaY, yVal;
            var dps = chart.options.data[0].dataPoints;
            for (var i = 0; i < dps.length; i++) {
                deltaY = (2 + Math.random() * (-2 - 2));
                yVal =  Math.min(Math.max(deltaY + dps[i].y, 0), 90);
                color = yVal > 75 ? "#FF2500" : yVal >= 50 ? "#FF6000" : yVal < 50 ? "#41CF35" : null;
                dps[i] = {label: "Core "+(i+1) , y: yVal, color: color};
            }
            chart.options.data[0].dataPoints = dps;
            chart.render();
        };
        updateChart();
        
        setInterval(function () { updateChart() }, 1000);
    }
</script>

<?php include '../footer.php'; ?>